<?php $__env->startSection('page_title', __('Basic Control')); ?>
<?php $__env->startPush('extra_styles'); ?>
	<link href="<?php echo e(asset('assets/dashboard/css/select2.min.css')); ?>" rel="stylesheet" type="text/css">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
	<div class="main-content">
		<section class="section">
			<div class="section-header">
				<h1><?php echo app('translator')->get('Basic Control'); ?></h1>
				<div class="section-header-breadcrumb">
					<div class="breadcrumb-item active">
						<a href="<?php echo e(route('admin.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
					</div>
					<div class="breadcrumb-item"><?php echo app('translator')->get('Basic Control'); ?></div>
				</div>
			</div>

			<div class="section-body">
				<div class="row mt-sm-4">
					<div class="col-12 col-md-4 col-lg-3">
						<?php echo $__env->make('admin.control_panel.components.sidebar', ['settings' => config('generalsettings.settings'), 'suffix' => 'Settings'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
					</div>
					<div class="col-12 col-md-8 col-lg-9">
						<div class="container-fluid" id="container-wrapper">
							<div class="row justify-content-md-center">
								<div class="col-lg-12">

									<div class="bd-callout bd-callout-warning mx-2">
										<i class="fas fa-info-circle mr-2"></i> <?php echo app('translator')->get("If you get 500(server error) for some reason, please turn on <b>Error Log</b> and try again. Then you can see what was missing in your system."); ?>
									</div>

									<div class="card mb-4 card-primary shadow">
										<div
											class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
											<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Basic Control'); ?></h6>
										</div>
										<div class="card-body">
											<form action="<?php echo e(route('basic.control')); ?>" method="post">
												<?php echo csrf_field(); ?>
												<div class="row">
													<div class="col-md-6">
														<div class="form-group">
															<label for="site_title"><?php echo app('translator')->get('Site Title'); ?></label>
															<input type="text" name="site_title"
																   value="<?php echo e(old('site_title',$basicControl->site_title)); ?>"
																   placeholder="<?php echo app('translator')->get('Site Title'); ?>"
																   class="form-control <?php $__errorArgs = ['site_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
															<div
																class="invalid-feedback"><?php $__errorArgs = ['site_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?></div>
														</div>
													</div>
													<div class="col-md-6">
														<div class="form-group">
															<label for="base_currency"><?php echo app('translator')->get('Base Currency'); ?></label>
															<select id="base_currency" name="base_currency"
																	class="form-control <?php $__errorArgs = ['base_currency'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
																<?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
																	<option data-code="<?php echo e($currency->code); ?>"
																			value="<?php echo e($currency->id); ?>" <?php echo e((old('base_currency',$basicControl->base_currency) == $currency->id) ? 'selected' : ''); ?>>
																		<?php echo e(__($currency->code).trans(' - ').__($currency->name)); ?>

																	</option>
																<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
															</select>
															<div
																class="invalid-feedback"><?php $__errorArgs = ['base_currency'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?></div>
														</div>
													</div>
													<div class="col-md-6 mb-3">
														<div class="form-group">
															<label for="time_zone"><?php echo app('translator')->get('Time Zone'); ?></label>
															<select name="time_zone"
																	class="select2-single form-control <?php $__errorArgs = ['time_zone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
																	id="time_zone">
																<?php $__currentLoopData = timezone_identifiers_list(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
																	<option
																		value="<?php echo e($value); ?>" <?php echo e((old('time_zone',$basicControl->time_zone) == $value ? ' selected' : '')); ?>><?php echo e(__($value)); ?></option>
																<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
															</select>
															<div
																class="invalid-feedback"><?php $__errorArgs = ['time_zone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?></div>
														</div>
													</div>
													<div class="col-md-6 mb-3">
														<div class="form-group">
															<label
																for="joining_bonus"><?php echo app('translator')->get('Joining Bonus Amount'); ?></label>
															<div class="input-group input-group-sm">
																<input type="text" name="joining_bonus"
																	   value="<?php echo e(old('joining_bonus',$basicControl->joining_bonus)); ?>"
																	   placeholder="<?php echo app('translator')->get('Joining Bonus'); ?>"
																	   class="form-control <?php $__errorArgs = ['joining_bonus'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
																<div class="input-group-append"><span
																		class="input-group-text joining-currency"><?php echo e(__(basicControl()->base_currency_code)); ?></span>
																</div>
																<div
																	class="invalid-feedback"><?php $__errorArgs = ['joining_bonus'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?></div>
															</div>
														</div>
													</div>
													<div class="col-md-4">
														<div class="form-group">
															<label><?php echo app('translator')->get('Signup Bonus'); ?></label>
															<div class="selectgroup w-100">
																<label class="selectgroup-item">
																	<input type="radio" name="signup_bonus_status"
																		   value="0"
																		   class="selectgroup-input" <?php echo e(old('signup_bonus_status', $basicControl->signup_bonus_status) == 0 ? 'checked' : ''); ?>>
																	<span class="selectgroup-button"><?php echo app('translator')->get('OFF'); ?></span>
																</label>
																<label class="selectgroup-item">
																	<input type="radio" name="signup_bonus_status"
																		   value="1"
																		   class="selectgroup-input" <?php echo e(old('signup_bonus_status', $basicControl->signup_bonus_status) == 1 ? 'checked' : ''); ?>>
																	<span class="selectgroup-button"><?php echo app('translator')->get('ON'); ?></span>
																</label>
															</div>
															<?php $__errorArgs = ['signup_bonus_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
															<span class="text-danger" role="alert">
																<strong><?php echo e(__($message)); ?></strong>
															</span>
															<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
														</div>
													</div>

													<div class="col-md-4">
														<div class="form-group">
															<label><?php echo app('translator')->get('Deposit Commission'); ?></label>
															<div class="selectgroup w-100">
																<label class="selectgroup-item">
																	<input type="radio" name="deposit_commission"
																		   value="0"
																		   class="selectgroup-input" <?php echo e(old('deposit_commission', $basicControl->deposit_commission) == 0 ? 'checked' : ''); ?>>
																	<span class="selectgroup-button"><?php echo app('translator')->get('OFF'); ?></span>
																</label>
																<label class="selectgroup-item">
																	<input type="radio" name="deposit_commission"
																		   value="1"
																		   class="selectgroup-input" <?php echo e(old('deposit_commission', $basicControl->deposit_commission) == 1 ? 'checked' : ''); ?>>
																	<span class="selectgroup-button"><?php echo app('translator')->get('ON'); ?></span>
																</label>
															</div>
															<?php $__errorArgs = ['deposit_commission'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
															<span class="text-danger" role="alert">
																<strong><?php echo e(__($message)); ?></strong>
															</span>
															<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
														</div>
													</div>
													<div class="col-md-4">
														<div class="form-group">
															<label><?php echo app('translator')->get('Error Log'); ?></label>
															<div class="selectgroup w-100">
																<label class="selectgroup-item">
																	<input type="radio" name="error_log" value="0"
																		   class="selectgroup-input" <?php echo e(old('error_log', $basicControl->error_log) == 0 ? 'checked' : ''); ?>>
																	<span class="selectgroup-button"><?php echo app('translator')->get('OFF'); ?></span>
																</label>
																<label class="selectgroup-item">
																	<input type="radio" name="error_log" value="1"
																		   class="selectgroup-input" <?php echo e(old('error_log', $basicControl->error_log) == 1 ? 'checked' : ''); ?>>
																	<span class="selectgroup-button"><?php echo app('translator')->get('ON'); ?></span>
																</label>
															</div>
															<?php $__errorArgs = ['error_log'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
															<span class="text-danger" role="alert">
																<strong><?php echo e(__($message)); ?></strong>
															</span>
															<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
														</div>
													</div>
												</div>
												<div class="row">
													<div class="col-md-4">
														<div class="form-group">
															<label><?php echo app('translator')->get('Cron Set Up Pop Up'); ?></label>
															<div class="selectgroup w-100">
																<label class="selectgroup-item">
																	<input type="radio"
																		   name="is_active_cron_notification" value="0"
																		   class="selectgroup-input" <?php echo e(old('is_active_cron_notification', $basicControl->is_active_cron_notification) == 0 ? 'checked' : ''); ?>>
																	<span class="selectgroup-button"><?php echo app('translator')->get('OFF'); ?></span>
																</label>
																<label class="selectgroup-item">
																	<input type="radio"
																		   name="is_active_cron_notification" value="1"
																		   class="selectgroup-input" <?php echo e(old('is_active_cron_notification', $basicControl->is_active_cron_notification) == 1 ? 'checked' : ''); ?>>
																	<span class="selectgroup-button"><?php echo app('translator')->get('ON'); ?></span>
																</label>
															</div>
															<?php $__errorArgs = ['is_active_cron_notification'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
															<span class="text-danger" role="alert">
																<strong><?php echo e(__($message)); ?></strong>
															</span>
															<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
														</div>
													</div>
													<div class="col-md-4">
														<div class="form-group">
															<label><?php echo app('translator')->get('Force SSL'); ?></label>
															<div class="selectgroup w-100">
																<label class="selectgroup-item">
																	<input type="radio"
																		   name="force_ssl" value="0"
																		   class="selectgroup-input" <?php echo e(old('force_ssl', $basicControl->force_ssl) == 0 ? 'checked' : ''); ?>>
																	<span class="selectgroup-button"><?php echo app('translator')->get('OFF'); ?></span>
																</label>
																<label class="selectgroup-item">
																	<input type="radio"
																		   name="force_ssl" value="1"
																		   class="selectgroup-input" <?php echo e(old('force_ssl', $basicControl->force_ssl) == 1 ? 'checked' : ''); ?>>
																	<span class="selectgroup-button"><?php echo app('translator')->get('ON'); ?></span>
																</label>
															</div>
															<?php $__errorArgs = ['force_ssl'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
															<span class="text-danger" role="alert">
																<strong><?php echo e(__($message)); ?></strong>
															</span>
															<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
														</div>
													</div>
												</div>
												<div class="row mb-2">
													<div class="col-md-12">
														<h6 class="my-3 font-weight-bold text-dark"><?php echo app('translator')->get('Color Settings'); ?></h6>
													</div>
													<div class="col-md-6">
														<div class="form-group">
															<label for="primaryColor"><?php echo app('translator')->get('Primary Color'); ?></label>
															<input type="color" name="primaryColor"
																   value="<?php echo e(old('primaryColor',$basicControl->primaryColor)); ?>"
																   class="form-control <?php $__errorArgs = ['primaryColor'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
															<div
																class="invalid-feedback"><?php $__errorArgs = ['primaryColor'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?></div>
														</div>
													</div>

													<div class="col-md-6">
														<div class="form-group">
															<label for="secondaryColor"><?php echo app('translator')->get('Secondary Color'); ?></label>
															<input type="color" name="secondaryColor"
																   value="<?php echo e(old('secondaryColor',$basicControl->secondaryColor)); ?>"
																   class="form-control <?php $__errorArgs = ['secondaryColor'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
															<div
																class="invalid-feedback"><?php $__errorArgs = ['secondaryColor'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?></div>
														</div>
													</div>
												</div>
												<div class="form-group">
													<button type="submit" name="submit"
															class="btn btn-primary btn-sm btn-block"><?php echo app('translator')->get('Save changes'); ?></button>
												</div>
											</form>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

		</section>
	</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('extra_scripts'); ?>
	<script src="<?php echo e(asset('assets/dashboard/js/select2.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('scripts'); ?>
	<script>
		'use strict'
		$(document).ready(function () {
			$('.select2-single').select2();
			$(document).on('change', '#base_currency', function (e) {
				e.preventDefault();
				$('.joining-currency').html($('#base_currency :selected').data("code"));
			});
		})
	</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/admin/control_panel/basic-control.blade.php ENDPATH**/ ?>