<?php $__env->startSection('page_title',__('Banks & Cards')); ?>

<?php $__env->startSection('content'); ?>
	<div class="main-content">
		<section class="section">
			<div class="section-header">
				<h1><?php echo app('translator')->get('Banks & Cards'); ?></h1>
				<div class="section-header-breadcrumb">
					<div class="breadcrumb-item active">
						<a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
					</div>
					<div class="breadcrumb-item"><?php echo app('translator')->get('Banks & Cards'); ?></div>
				</div>
			</div>
			<!------ alert ------>
			<div class="row ">
				<div class="col-md-12">
					<div class="bd-callout bd-callout-primary mx-2">
						<i class="fa-3x fas fa-info-circle text-primary"></i> <?php echo app('translator')->get(optional($template->description)->short_description); ?>
					</div>
				</div>
			</div>
			<?php if(!empty($cardOrder)): ?>
				<?php if($cardOrder->status == 0 || $cardOrder->status == 3): ?>
					<div class="media align-items-center d-flex justify-content-between alert alert-warn mb-4">
						<div><i
								class="fas fa-exclamation-triangle"></i> <?php echo app('translator')->get('Your virtual card request is pending.'); ?>
						</div>
					</div>
				<?php endif; ?>
				<?php if($cardOrder->status == 2): ?>
					<div class="media align-items-center d-flex justify-content-between alert alert-warn mb-4">
						<div><i
								class="fas fa-exclamation-triangle"></i> <?php echo app('translator')->get('Your virtual card request is rejected by authority.'); ?>
						</div>
						<div class="media align-items-center d-flex justify-content-between">
							<a href="javascript:void(0)" data-target="#rejectReason" data-toggle="modal"
							   class="btn btn-dark mr-2"><?php echo app('translator')->get('Reason'); ?></a>
							<?php if($cardOrder->resubmitted == 1): ?>
								<a href="<?php echo e(route('user.virtual.card.orderReSubmit')); ?>"
								   class="btn btn-primary"><?php echo app('translator')->get('Resubmit Now'); ?></a>
							<?php endif; ?>
						</div>
					</div>
				<?php endif; ?>
				<?php if($cardOrder->status == 4): ?>
					<div class="media align-items-center d-flex justify-content-between alert alert-warn mb-4">
						<div><i
								class="fas fa-exclamation-triangle"></i> <?php echo app('translator')->get('Your virtual card request is generated please make it complete.'); ?>
						</div>
						<div class="media align-items-center d-flex justify-content-between">
							<a href="<?php echo e(route('order.confirm',$cardOrder->id)); ?>"
							   class="btn btn-primary"><?php echo app('translator')->get('Confirm'); ?></a>
						</div>
					</div>
				<?php endif; ?>
			<?php endif; ?>
			<div class="row mb-3">
				<div class="container-fluid" id="container-wrapper">
					<div class="row justify-content-md-center">
						<?php if(count($approveCards)>0): ?>
							<?php $__currentLoopData = $approveCards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $card): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<div class="col-md-4 p-2">
									<div class="bank-card-box">
										<div class="top-area">
											<div class="icon">
												<i class="fas fa-credit-card"></i>
											</div>
											<div class="text">
												<h5><?php echo e($card->card_number); ?> | <span><?php echo e($card->currency); ?></span></h5>
												<span><?php echo e($card->name_on_card); ?></span>
											</div>
											<?php if($card->status == 5): ?>
												<p class="ml-5 text-danger"><?php echo app('translator')->get('Requested Block'); ?></p>
											<?php endif; ?>

											<div class="setting-area">
												<div class="dropdown sidebar-dropdown-items">
													<button class="dropdown-toggle" type="button" data-toggle="dropdown"
															aria-expanded="false">
														<i class="fas fa-cog"></i>
													</button>
													<div class="dropdown-menu">
														<?php if($card->status != 9): ?>
															<a class="dropdown-item"
															   href="<?php echo e(route('fund.initialize',['card',$card->id])); ?>"><?php echo app('translator')->get('Add Fund'); ?></a>
															<?php if($card->status != 5 && $card->status != 6): ?>
																<a class="dropdown-item blockRqst"
																   data-target="#blockRqst"
																   data-toggle="modal"
																   data-route="<?php echo e(route('user.virtual.cardBlock',$card->id)); ?>"
																   href="javascript:void(0)"><?php echo app('translator')->get('Block Card'); ?></a>
															<?php endif; ?>
														<?php endif; ?>
														<a class="dropdown-item"
														   href="<?php echo e(route('user.virtual.cardTransaction',$card->card_Id)); ?>"><?php echo app('translator')->get('Transaction'); ?></a>
													</div>
												</div>
											</div>
										</div>
										<div class="bottom-area d-flex justify-content-between align-items-end">
											<div>
												<span
													class="badge <?php echo e(($card->is_active == 'Active') ? 'badge-success':'badge-danger'); ?> mb-3"><?php echo e($card->is_active); ?></span>
												<p class="mb-0"><?php echo app('translator')->get('Valid Thru:'); ?> <?php echo e(\Carbon\Carbon::parse($card->expiry_date)->format('m/y')); ?></p>
											</div>
											<div>
												<p class="mb-1"><?php echo app('translator')->get('CVV:'); ?> <?php echo e($card->cvv); ?></p>
												<h4 class="balance mb-1"><?php echo e(getAmount($card->balance,2)); ?> <?php echo e($card->currency); ?></h4>
											</div>
										</div>
									</div>

								</div>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						<?php endif; ?>
						<div class="col-md-4 p-2">
							<a href="<?php echo e(route('user.virtual.card.order')); ?>" class="decoration__none">
								<div class="bank-card-box">
									<div class="top-area">
										<div class="icon">
											<i class="fas fa-credit-card"></i>
										</div>
										<div class="text">
											<div class="d-flex justify-content-start">
												<h5 class="mr-2"><?php echo app('translator')->get('Request a Card'); ?></h5>
												<?php if($orderLock == 'true'): ?>
													<i class="fa fa-lock"></i>
												<?php endif; ?>
											</div>
											<span
												class="text-danger"><?php echo app('translator')->get('Per Card Request Charge'); ?> <?php echo e(basicControl()->v_card_charge); ?> <?php echo e(config('basic.base_currency_code')); ?></span>
										</div>
									</div>
								</div>
							</a>
						</div>
					</div>
				</div>
			</div>
		</section>
	</div>
	<?php if(!empty($cardOrder)): ?>
		<?php if($cardOrder->status == 2): ?>
			<div id="rejectReason" class="modal fade" tabindex="-1" role="dialog"
				 aria-labelledby="primary-header-modalLabel"
				 aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content">
						<div class="modal-header">
							<h4 class="modal-title text-dark font-weight-bold"
								id="primary-header-modalLabel"><?php echo app('translator')->get('Rejected Reason '); ?></h4>
							<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
						</div>
						<div class="modal-body">
							<div class="row mt-2">
								<div class="col-md-12">
									<lable><?php echo app('translator')->get('Reasons'); ?></lable>
									<textarea class="form-control" readonly><?php echo e($cardOrder->reason); ?></textarea>
								</div>
							</div>
						</div>
						<div class="modal-footer">
							<button type="button" class="btn btn-dark" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
						</div>
					</div>
				</div>
			</div>
		<?php endif; ?>
	<?php endif; ?>

	
	<div id="blockRqst" class="modal fade" tabindex="-1" role="dialog"
		 aria-labelledby="primary-header-modalLabel"
		 aria-hidden="true">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title text-dark font-weight-bold"
						id="primary-header-modalLabel"><?php echo app('translator')->get('Block Confirmation'); ?></h4>
					<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
				</div>
				<form action="" method="post" class="blockForm">
					<?php echo csrf_field(); ?>
					<div class="modal-body">
						<p><?php echo app('translator')->get('Are You sure to send block request for this card ?'); ?></p>
						<div class="row">
							<div class="col-md-12">
								<label><?php echo app('translator')->get('Reason For Block'); ?></label>
								<textarea class="form-control" name="reason"></textarea>
								<?php $__errorArgs = ['reason'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
								<span class="text-danger"><?php echo e($message); ?></span>
								<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
							</div>
						</div>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-dark" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
						<button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Yes'); ?></button>
					</div>
				</form>
			</div>
		</div>
	</div>

	
	<div id="fundRqst" class="modal fade" tabindex="-1" role="dialog"
		 aria-labelledby="primary-header-modalLabel"
		 aria-hidden="true">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title text-dark font-weight-bold"
						id="primary-header-modalLabel"><?php echo app('translator')->get('Add Fund Confirmation'); ?></h4>
					<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
				</div>
				<form action="<?php echo e(route('fund.initialize')); ?>" method="post" class="blockForm">
					<?php echo csrf_field(); ?>
					<div class="modal-body">
						<p><?php echo app('translator')->get('Are You sure to send fund request for this card ?'); ?></p>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-dark" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
						<button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Yes'); ?></button>
					</div>
				</form>
			</div>
		</div>
	</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('extra_styles'); ?>

<?php $__env->stopPush(); ?>
<?php $__env->startSection('scripts'); ?>
	<script>
		'use strict';
		$(document).on('click', '.blockRqst', function () {
			var route = $(this).data('route');
			$('.blockForm').attr('action', route);
		})
	</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/user/virtual_card/cardForm.blade.php ENDPATH**/ ?>