<?php $__env->startSection('page_title', __('All SMS Templates')); ?>
<?php $__env->startPush('extra_styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/dashboard/css/dataTables.bootstrap4.min.css')); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
<div class="main-content">
	<section class="section">
		<div class="section-header">
			<h1><?php echo app('translator')->get('All SMS Templates'); ?></h1>
			<div class="section-header-breadcrumb">
				<div class="breadcrumb-item active">
					<a href="<?php echo e(route('admin.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
				</div>
				<div class="breadcrumb-item"><?php echo app('translator')->get('All SMS Templates'); ?></div>
			</div>
		</div>


		<div class="section-body">
			<div class="row mt-sm-4">
				<div class="col-12 col-md-4 col-lg-3">
					<?php echo $__env->make('admin.control_panel.components.sidebar', ['settings' => config('generalsettings.sms'), 'suffix' => ''], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
				</div>
				<div class="col-12 col-md-8 col-lg-9">
					<div class="container-fluid" id="container-wrapper">
						<div class="row justify-content-md-center">
							<div class="col-lg-12">
								<div class="card mb-4 card-primary shadow">
									<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
										<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('List of all templates'); ?></h6>
									</div>
									<div class="card-body">
										<div class="table-responsive">
											<table class="table table-striped table-hover align-items-center table-flush table-sm" id="emailTemplate">
												<thead class="thead-light">
												<tr>
													<th><?php echo app('translator')->get('No.'); ?></th>
													<th><?php echo app('translator')->get('Name'); ?></th>
													<th><?php echo app('translator')->get('Status'); ?></th>
													<th><?php echo app('translator')->get('Action'); ?></th>
												</tr>
												</thead>
												<tbody>
												<?php $__currentLoopData = $smsTemplates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $template): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
													<tr>
														<td data-label="<?php echo app('translator')->get('No.'); ?>"><?php echo e(__($loop->iteration)); ?></td>
														<td data-label="<?php echo app('translator')->get('Name'); ?>"><?php echo e(__($template->name)); ?></td>
														<td data-label="<?php echo app('translator')->get('Status'); ?>">
														<span class="badge badge-pill badge-<?php echo e(($template->mail_status == 1) ? 'success' : 'danger'); ?>">
															<?php echo e(($template->mail_status == 1) ? trans('Active') : trans('Deactivate')); ?>

														</span>
														</td>
														<td data-label="<?php echo app('translator')->get('Action'); ?>">
															<a href="<?php echo e(route('sms.template.edit',$template->id)); ?>"
															   class="btn btn-sm btn-outline-primary"><i class="fas fa-edit"></i> <?php echo app('translator')->get('Edit'); ?>
															</a>
														</td>
													</tr>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
												</tbody>
											</table>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>

				</div>
			</div>
		</div>

	</section>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('extra_scripts'); ?>
    <script src="<?php echo e(asset('assets/dashboard/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/dashboard/js/dataTables.bootstrap4.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        'use strict';
        $(document).ready(function () {
            $('#emailTemplate').DataTable();
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/admin/smsTemplate/show.blade.php ENDPATH**/ ?>