<?php $__env->startSection('page_title', __('Product Stock')); ?>

<?php $__env->startSection('content'); ?>
	<div class="main-content" id="store" v-cloak>
		<section class="section">
			<div class="section-header">
				<h1><?php echo app('translator')->get('Product Stock'); ?></h1>
				<div class="section-header-breadcrumb">
					<div class="breadcrumb-item active">
						<a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
					</div>
					<div class="breadcrumb-item"><?php echo app('translator')->get('Product Stock'); ?></div>
				</div>
			</div>
			<div class="section-body">
				<div class="row mt-sm-4">
					<div class="col-12 col-md-12 col-lg-12">
						<div class="container-fluid" id="container-wrapper">
							<div class="row justify-content-md-center">
								<div class="col-lg-12">
									<div class="card mb-4 card-primary shadow">
										<div
											class="card-header py-3 d-flex flex-wrap flex-row align-items-center justify-content-between">
											<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Product Stock'); ?></h6>
											<a href="<?php echo e(route('stock.create')); ?>"
											   class="btn btn-primary"><?php echo app('translator')->get('Create Stock'); ?></a>
										</div>
										<div class="card-body">
											<div class="table-responsive">
												<table
													class="table table-striped table-hover align-items-center table-flush"
													id="data-table">
													<thead class="thead-light">
													<tr>
														<th><?php echo app('translator')->get('SL.'); ?></th>
														<th><?php echo app('translator')->get('Name'); ?></th>
														<th><?php echo app('translator')->get('Quantity'); ?></th>
														<th><?php echo app('translator')->get('Action'); ?></th>
													</tr>
													</thead>
													<tbody>
													<?php $__currentLoopData = $productStocks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
														<tr>
															<td data-label="<?php echo app('translator')->get('SL.'); ?>"><?php echo e(++$key); ?></td>
															<td data-label="Name">
																<a href="<?php echo e(route('product.edit',$item->product_id)); ?>"
																   class="text-decoration-none">
																	<div class="d-lg-flex d-block align-items-center ">
																		<div class="mr-3"><img
																				src="<?php echo e(getFile(config('location.product.path').optional($item->product)->thumbnail)); ?>"
																				alt="user" class="rounded-circle"
																				width="40" data-toggle="tooltip"
																				title=""
																				data-original-title="<?php echo e(optional($item->product)->name); ?>">
																		</div>
																		<div
																			class="d-inline-flex d-lg-block align-items-center">
																			<p class="text-dark mb-0 font-16 font-weight-medium">
																				<?php echo e(optional($item->product)->name); ?></p>
																			<span
																				class="text-muted font-14 ml-1"><?php echo e(optional($item->product)->sku); ?></span>
																		</div>
																	</div>
																</a>
															</td>
															<td data-label="<?php echo app('translator')->get('Quantity'); ?>"><?php echo e($item->sumQuantity); ?></td>
															<td data-label="<?php echo app('translator')->get('Action'); ?>">
																<a href="<?php echo e(route('stock.view',$item->product_id)); ?>"
																   class="btn btn-outline-primary btn-sm mr-2"><i
																		class="fas fa-eye"></i></a>
																<a href="javascript:void(0)"
																   data-target="#attrDelete"
																   data-toggle="modal"
																   data-route="<?php echo e(route('attr.delete',$item->id)); ?>"
																   class="btn btn-outline-danger btn-sm deleteAttr"><i
																		class="fas fa-trash"></i></a>
															</td>
														</tr>
													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
													</tbody>
												</table>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
	</div>
	<div id="attrDelete" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="primary-header-modalLabel"
		 aria-hidden="true">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title text-danger" id="primary-header-modalLabel"><?php echo app('translator')->get('Attribute Delete'); ?></h4>
					<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
				</div>
				<?php echo csrf_field(); ?>
				<div class="modal-body">
					<p><?php echo app('translator')->get('Are you want to delete this Attribute?'); ?></p>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-dark" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
					<form action="" method="post" class="deleteAttrForm">
						<?php echo csrf_field(); ?>
						<?php echo method_field('delete'); ?>
						<button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Submit'); ?></button>
					</form>
				</div>
			</div>
		</div>
	</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('extra_scripts'); ?>

<?php $__env->stopPush(); ?>
<?php $__env->startSection('scripts'); ?>
	<script>
		'use strict'

		$(document).on('click', '.deleteAttr', function () {
			var route = $(this).data('route');
			$('.deleteAttrForm').attr('action', route);
		})

	</script>
	<?php if($errors->any()): ?>
		<?php
			$collection = collect($errors->all());
			$errors = $collection->unique();
		?>
		<script>
			"use strict";
			<?php $__currentLoopData = $errors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			Notiflix.Notify.Failure("<?php echo e(trans($error)); ?>");
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		</script>
	<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/user/store/productStock/stockList.blade.php ENDPATH**/ ?>