<?php $__env->startSection('page_title', __('Redeem Code List')); ?>

<?php $__env->startSection('content'); ?>
	<div class="main-content">
		<section class="section">
			<div class="section-header">
				<h1><?php echo app('translator')->get('Redeem Code List'); ?></h1>
				<div class="section-header-breadcrumb">
					<div class="breadcrumb-item active">
						<a href="<?php echo e(route('admin.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
					</div>
					<div class="breadcrumb-item"><?php echo app('translator')->get('Redeem Code List'); ?></div>
				</div>
			</div>

			<div class="row mb-3">
				<div class="container-fluid" id="container-wrapper">
					<div class="row">
						<div class="col-lg-12">
							<div class="card mb-4 card-primary shadow-sm">
								<div
									class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
									<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Search'); ?></h6>
								</div>
								<div class="card-body">
									<?php if(isset($userId)): ?>
										<form action="<?php echo e(route('admin.user.redeem.search',$userId)); ?>" method="get">
											<?php echo $__env->make('admin.redeem.searchForm', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
										</form>
									<?php else: ?>
										<form action="<?php echo e(route('admin.redeem.search')); ?>" method="get">
											<?php echo $__env->make('admin.redeem.searchForm', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
										</form>
									<?php endif; ?>
								</div>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-lg-12">
							<div class="card mb-4 card-primary shadow">
								<div
									class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
									<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Redeem Code List'); ?></h6>
								</div>
								<div class="card-body">
									<div class="table-responsive">
										<table
											class="table table-striped table-hover align-items-center table-borderless">
											<thead class="thead-light">
											<tr>
												<th><?php echo app('translator')->get('SL'); ?></th>
												<th><?php echo app('translator')->get('Sender'); ?></th>
												<th><?php echo app('translator')->get('Receiver'); ?></th>
												<th><?php echo app('translator')->get('Receiver E-Mail'); ?></th>
												<th><?php echo app('translator')->get('Amount'); ?></th>
												<th><?php echo app('translator')->get('Transaction ID'); ?></th>
												<th><?php echo app('translator')->get('Status'); ?></th>
												<th><?php echo app('translator')->get('Created At'); ?></th>
											</tr>
											</thead>
											<tbody>
											<?php $__empty_1 = true; $__currentLoopData = $redeemCodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
												<tr>

													<td data-label="<?php echo app('translator')->get('SL'); ?>">
														<?php echo e(loopIndex($redeemCodes) + $key); ?>

													</td>
													<td data-label="<?php echo app('translator')->get('Sender'); ?>">
														<a href="<?php echo e(route('user.edit', $value->sender_id)); ?>"
														   class="text-decoration-none">
															<div class="d-lg-flex d-block align-items-center ">
																<div class="mr-3"><img
																		src="<?php echo e(optional($value->sender)->profilePicture() ??asset('assets/upload/boy.png')); ?>"
																		alt="user"
																		class="rounded-circle" width="35"
																		data-toggle="tooltip" title=""
																		data-original-title="<?php echo e(optional($value->sender)->name?? __('N/A')); ?>">
																</div>
																<div
																	class="d-inline-flex d-lg-block align-items-center">
																	<p class="text-dark mb-0 font-16 font-weight-medium"><?php echo e(Str::limit(optional($value->sender)->name?? __('N/A'),20)); ?></p>
																	<span
																		class="text-muted font-14 ml-1"><?php echo e('@'.optional($value->sender)->username?? __('N/A')); ?></span>
																</div>
															</div>
														</a>
													</td>


													<td data-label="<?php echo app('translator')->get('Receiver'); ?>">
														<?php if($value->receiver_id): ?>
															<a href="<?php echo e(($value->receiver_id)? route('user.edit', $value->receiver_id):"#0"); ?>"
															   class="text-decoration-none">
																<div class="d-lg-flex d-block align-items-center ">
																	<div class="mr-3"><img
																			src="<?php echo e(optional($value->receiver)->profilePicture()??asset('assets/upload/boy.png')); ?>"
																			alt="user"
																			class="rounded-circle" width="35"
																			data-toggle="tooltip" title=""
																			data-original-title="<?php echo e(optional($value->receiver)->name?? __('N/A')); ?>">
																	</div>
																	<div
																		class="d-inline-flex d-lg-block align-items-center">
																		<p class="text-dark mb-0 font-16 font-weight-medium"><?php echo e(Str::limit(optional($value->receiver)->name?? __('N/A'),20)); ?></p>
																		<span
																			class="text-muted font-14 ml-1"><?php echo e('@'.optional($value->receiver)->username?? __('N/A')); ?></span>
																	</div>
																</div>
															</a>
														<?php else: ?>
															<?php echo e(__('N/A')); ?>

														<?php endif; ?>
													</td>

													<td data-label="<?php echo app('translator')->get('Receiver E-Mail'); ?>"><?php echo e(__($value->email ?? __('N/A'))); ?></td>

													<td data-label="<?php echo app('translator')->get('Amount'); ?>"><?php echo e((getAmount($value->amount)).' '.__(optional($value->currency)->code)); ?></td>
													<td data-label="<?php echo app('translator')->get('Transaction ID'); ?>"><?php echo e(__($value->utr)); ?></td>
													<td data-label="<?php echo app('translator')->get('Status'); ?>">
														<?php if($value->status == 1): ?>
															<span class="badge badge-info"><?php echo app('translator')->get('Unused'); ?></span>
														<?php elseif($value->status == 2): ?>
															<span class="badge badge-success"><?php echo app('translator')->get('Used'); ?></span>
														<?php else: ?>
															<span class="badge badge-warning"><?php echo app('translator')->get('Pending'); ?></span>
														<?php endif; ?>
													</td>
													<td data-label="<?php echo app('translator')->get('Created At'); ?>"> <?php echo e(dateTime($value->created_at)); ?> </td>
												</tr>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
												<tr>
													<th colspan="100%" class="text-center"><?php echo app('translator')->get('No data found'); ?></th>
												</tr>
											<?php endif; ?>
											</tbody>
										</table>
									</div>
									<div class="card-footer">
										<?php echo e($redeemCodes->links()); ?>

									</div>

								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

		</section>
	</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/admin/redeem/index.blade.php ENDPATH**/ ?>