<?php $__env->startSection('page_title', __('Edit SMS Template')); ?>
<?php $__env->startSection('content'); ?>
<div class="main-content">
	<section class="section">
		<div class="section-header">
			<h1><?php echo app('translator')->get('Edit SMS Template'); ?></h1>
			<div class="section-header-breadcrumb">
				<div class="breadcrumb-item active">
					<a href="<?php echo e(route('admin.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
				</div>
				<div class="breadcrumb-item"><?php echo app('translator')->get('Edit SMS Template'); ?></div>
			</div>
		</div>

		<div class="card card-primary shadow m-0 m-md-4 my-4 m-md-0">
			<div class="card-body">
				<div class="table-responsive">
					<table class="table align-items-center table-flush table-sm" id="emailTemplate">
						<thead class="thead-light">
						<tr>
							<th> <?php echo app('translator')->get('SHORTCODE'); ?> </th>
							<th> <?php echo app('translator')->get('DESCRIPTION'); ?> </th>
						</tr>
						</thead>
						<tbody>
						<?php if($smsTemplate->short_keys): ?>
							<?php $__currentLoopData = $smsTemplate->short_keys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<tr>
									<td>
										<pre>[[<?php echo app('translator')->get($key); ?>]]</pre>
									</td>
									<td> <?php echo app('translator')->get($value); ?> </td>
								</tr>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						<?php endif; ?>
						</tbody>
					</table>
				</div>
			</div>
		</div>
		<div class="card card-primary shadow m-0 m-md-4 my-4 m-md-0">
			<div class="card-body">
				<ul class="nav nav-tabs mb-3">
					<?php $__currentLoopData = $smsTemplates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<li class="nav-item">
							<a href="#tab-<?php echo e($value->id); ?>" data-toggle="tab"
							   aria-expanded="<?php echo e(($key == 0) ? 'true' : 'false'); ?>"
							   class="nav-link <?php echo e(($key == 0) ? 'active' : ''); ?>">
								<i class="mdi mdi-home-variant d-lg-none d-block mr-1"></i>
								<span class=""><?php echo e(__(optional($value->language)->name)); ?></span>
							</a>
						</li>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</ul>
				<div class="tab-content">
					<?php $__currentLoopData = $smsTemplates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<div class="tab-pane <?php echo e(($key == 0) ? 'show active' : ''); ?>" id="tab-<?php echo e($value->id); ?>">
							<h3 class="card-title my-3"><?php echo e(trans('SMS in')); ?> <?php echo e(__(optional($value->language)->name)); ?>

								: <?php echo e(__($value->name)); ?></h3>
							<form action="<?php echo e(route('sms.template.update',$value->id)); ?>" method="POST"
								  class="mt-4">
								<?php echo csrf_field(); ?>
								<div class="col-md-4">
									<div class="form-group">
										<label><?php echo app('translator')->get('Status'); ?></label>
										<div class="selectgroup w-100">
											<label class="selectgroup-item">
												<input type="radio" name="sms_status" value="0"
													   class="selectgroup-input" <?php echo e(old('sms_status', $value->sms_status) == 0 ? 'checked' : ''); ?>>
												<span class="selectgroup-button"><?php echo app('translator')->get('OFF'); ?></span>
											</label>
											<label class="selectgroup-item">
												<input type="radio" name="sms_status" value="1"
													   class="selectgroup-input" <?php echo e(old('sms_status', $value->sms_status) == 1 ? 'checked' : ''); ?>>
												<span class="selectgroup-button"><?php echo app('translator')->get('ON'); ?></span>
											</label>
										</div>
										<?php $__errorArgs = ['sms_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
											<span class="text-danger" role="alert">
												<strong><?php echo e(__($message)); ?></strong>
											</span>
										<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
									</div>
								</div>
								<div class="row">
									<div class="col-sm-12 form-group">
										<label><?php echo app('translator')->get('Message Body'); ?></label>
										<textarea class="form-control form-control-sm" name="sms_body"
												  rows="10"><?php echo e($value->sms_body); ?></textarea>
										<?php if($errors->has('sms_body')): ?>
											<div class="error text-danger"><?php echo app('translator')->get($errors->first('sms_body')); ?> </div>
										<?php endif; ?>
									</div>
								</div>
								<button type="submit" class="btn btn-sm btn-primary btn-block mt-3">
									<?php echo app('translator')->get('Save Changes'); ?>
								</button>
							</form>
						</div>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</div>
			</div>
		</div>

	</section>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/admin/smsTemplate/edit.blade.php ENDPATH**/ ?>