<?php $__env->startSection('page_title',__('Transactions')); ?>

<?php $__env->startSection('content'); ?>
	<div class="main-content">
		<section class="section">
			<div class="section-header">
				<h1><?php echo app('translator')->get('Transactions'); ?></h1>
				<div class="section-header-breadcrumb">
					<div class="breadcrumb-item active">
						<a href="<?php echo e(route('admin.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
					</div>
					<div class="breadcrumb-item"><?php echo app('translator')->get('Transactions'); ?></div>
				</div>
			</div>

			<div class="row mb-3">
				<div class="container-fluid" id="container-wrapper">
					<div class="row">
						<div class="col-lg-12">
							<div class="card mb-4 card-primary shadow-sm">
								<div
									class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
									<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Search'); ?></h6>
								</div>
								<div class="card-body">
									<form action="<?php echo e(route('admin.transaction.search')); ?>" method="get">
										<?php echo $__env->make('admin.transaction.searchForm', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
									</form>
								</div>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-lg-12">
							<div class="card mb-4 card-primary shadow">
								<div
									class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
									<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Transactions'); ?></h6>
								</div>
								<div class="card-body">
									<div class="table-responsive">
										<table
											class="table table-striped table-hover align-items-center table-borderless">
											<thead class="thead-light">
											<tr>
												<th><?php echo app('translator')->get('SL'); ?></th>
												<th><?php echo app('translator')->get('Sender'); ?></th>
												<th><?php echo app('translator')->get('Receiver'); ?></th>
												<th><?php echo app('translator')->get('Receiver E-Mail'); ?></th>
												<th><?php echo app('translator')->get('Transaction ID'); ?></th>
												<th><?php echo app('translator')->get('Amount'); ?></th>
												<th><?php echo app('translator')->get('Type'); ?></th>
												<th><?php echo app('translator')->get('Status'); ?></th>
												<th><?php echo app('translator')->get('Transaction At'); ?></th>
											</tr>
											</thead>
											<tbody>
											<?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
												<tr>
													<td data-label="<?php echo app('translator')->get('SL'); ?>">
														<?php echo e(loopIndex($transactions) + $key); ?>

													</td>
													<td data-label="<?php echo app('translator')->get('Sender'); ?>">
														<?php if($value->transactional_type == 'App\Models\ProductOrder' || $value->transactional_type == 'App\Models\QRCode'): ?>
															<?php echo e(__($value->transactional->email ?? __('N/A'))); ?>

														<?php elseif($value->transactional_type == 'App\Models\VirtualCardTransaction'): ?>
															<?php echo e(__(optional(optional($value->transactional)->user)->name ?? __('N/A'))); ?>

														<?php elseif($value->transactional_type == 'App\Models\VirtualCardOrder'): ?>
															<?php echo app('translator')->get('Admin'); ?>
														<?php elseif($value->transactional_type == \App\Models\Fund::class && optional($value->transactional)->card_order_id != null): ?>
															<?php echo e(__(optional(optional($value->transactional)->receiver)->name) ?? __('N/A')); ?>

														<?php elseif($value->transactional_type == App\Models\BillPay::class && $value->currency_code != null): ?>
															<?php echo e(__(optional($value->transactional->user)->name) ?? __('N/A')); ?>

														<?php elseif($value->transactional_type == App\Models\BillPay::class && $value->currency_code == null): ?>
															<?php echo app('translator')->get('Admin'); ?>
														<?php else: ?>
															<?php echo e(__(optional(optional($value->transactional)->sender)->name ?? __('N/A'))); ?>

														<?php endif; ?>
													</td>
													<td data-label="<?php echo app('translator')->get('Receiver'); ?>">
														<?php if($value->transactional_type == 'App\Models\ProductOrder' || $value->transactional_type == App\Models\ApiOrder::class || $value->transactional_type == 'App\Models\QRCode' || $value->transactional_type == 'App\Models\VirtualCardOrder'): ?>
															<?php echo e(__(optional(optional($value->transactional)->user)->name ?? __('N/A'))); ?>

														<?php elseif($value->transactional_type == \App\Models\Fund::class && optional($value->transactional)->card_order_id != null): ?>
															<?php echo app('translator')->get('Admin'); ?>
														<?php elseif($value->transactional_type == App\Models\BillPay::class && $value->currency_code == null): ?>
															<?php echo e(__(optional($value->transactional->user)->name) ?? __('N/A')); ?>

														<?php else: ?>
															<?php echo e(__(optional(optional($value->transactional)->receiver)->name ?? __('N/A'))); ?>

														<?php endif; ?>
													</td>
													<td data-label="<?php echo app('translator')->get('Receiver E-Mail'); ?>">
														<?php if($value->transactional_type == 'App\Models\ProductOrder' || $value->transactional_type == App\Models\ApiOrder::class || $value->transactional_type == 'App\Models\QRCode' || $value->transactional_type == 'App\Models\VirtualCardOrder'): ?>
															<?php echo e(__(optional($value->transactional->user)->email)); ?>

														<?php elseif($value->transactional_type == 'App\Models\VirtualCardTransaction'): ?>
															-
														<?php elseif($value->transactional_type == \App\Models\Fund::class && optional($value->transactional)->card_order_id != null): ?>
															-
														<?php elseif($value->transactional_type == App\Models\BillPay::class && $value->currency_code == null): ?>
															<?php echo e(__(optional($value->transactional->user)->email) ?? __('N/A')); ?>

														<?php else: ?>
															<?php echo e(__(optional($value->transactional)->email)??optional($value->transactional)->customer_email); ?>

														<?php endif; ?>
													</td>
													<td data-label="<?php echo app('translator')->get('Transaction ID'); ?>">
														<?php if($value->transactional_type == 'App\Models\ProductOrder' || $value->transactional_type == 'App\Models\QRCode' || $value->transactional_type == 'App\Models\VirtualCardTransaction' || $value->transactional_type == 'App\Models\VirtualCardOrder'): ?>
															-
														<?php else: ?>
															<?php echo e(__(optional($value->transactional)->utr)??optional($value->transactional)->has_slug); ?>

														<?php endif; ?>
													</td>
													<?php if($value->transactional_type == 'App\Models\VirtualCardOrder'): ?>
														<td data-label="<?php echo app('translator')->get('Amount'); ?>"><?php echo e((getAmount($value->amount)).' '.__(optional($value->transactional)->currency)); ?></td>
													<?php elseif($value->transactional_type == 'App\Models\BillPay' && $value->currency_code != null): ?>
														<td data-label="<?php echo app('translator')->get('Amount'); ?>"><?php echo e(getAmount(optional($value->transactional)->amount)); ?> <?php echo e($value->currency_code); ?></td>
													<?php elseif($value->transactional_type == 'App\Models\BillPay' && $value->currency_code == null): ?>
														<td data-label="<?php echo app('translator')->get('Amount'); ?>"><?php echo e(getAmount(optional($value->transactional)->amount)); ?> <?php echo e(optional($value->transactional->baseCurrency)->code); ?></td>
													<?php elseif(optional($value->transactional)->amount != 0): ?>
														<td data-label="<?php echo app('translator')->get('Amount'); ?>"><?php echo e((getAmount(optional($value->transactional)->amount)).' '.__(optional(optional($value->transactional)->currency)->code)); ?></td>
													<?php else: ?>
														<?php if($value->transactional_type == 'App\Models\ProductOrder'): ?>
															<td data-label="<?php echo app('translator')->get('Amount'); ?>"><?php echo e((getAmount(optional($value->transactional)->total_amount))+(getAmount(optional($value->transactional)->shipping_charge)).' '.__(optional(optional($value->transactional)->currency)->code)); ?></td>
														<?php else: ?>
															<td data-label="<?php echo app('translator')->get('Amount'); ?>">
																<?php echo e((getAmount(optional($value->transactional)->grand_total)).' '.__(optional(optional($value->transactional)->currency)->code)); ?></td>
														<?php endif; ?>
													<?php endif; ?>
													<td data-label="<?php echo app('translator')->get('Type'); ?>">
														<?php if($value->transactional_type == \App\Models\QRCode::class): ?>
															<?php echo e(__('QR Payment')); ?>

														<?php elseif($value->transactional_type == \App\Models\VirtualCardOrder::class): ?>
															<?php echo e(__('VirtualCard')); ?>

														<?php elseif($value->transactional_type == \App\Models\Fund::class && optional($value->transactional)->card_order_id != null): ?>
															<?php echo e(__('Card Fund')); ?>

														<?php else: ?>
															<?php echo e(__(str_replace('App\Models\\', '', $value->transactional_type))); ?>

														<?php endif; ?>
													</td>
													<td data-label="<?php echo app('translator')->get('Status'); ?>">
														<?php if($value->transactional_type == 'App\Models\Invoice'): ?>
															<?php if($value->transactional->status == 'paid'): ?>
																<span
																	class="badge badge-success"><?php echo app('translator')->get('Paid'); ?></span>
															<?php elseif($value->transactional->status == 'rejected'): ?>
																<span
																	class="badge badge-danger"><?php echo app('translator')->get('Rejected'); ?></span>
															<?php endif; ?>
														<?php elseif($value->transactional_type == 'App\Models\Voucher'): ?>
															<?php if($value->transactional->status): ?>
																<span
																	class="badge badge-success"><?php echo app('translator')->get('Success'); ?></span>
															<?php else: ?>
																<span
																	class="badge badge-warning"><?php echo app('translator')->get('Pending'); ?></span>
															<?php endif; ?>
														<?php elseif($value->transactional_type == 'App\Models\ProductOrder'): ?>
															<?php if($value->transactional->status == 1): ?>
																<span
																	class="badge badge-success"><?php echo app('translator')->get('Paid'); ?></span>
															<?php else: ?>
																<span
																	class="badge badge-warning"><?php echo app('translator')->get('Pending'); ?></span>
															<?php endif; ?>

														<?php elseif($value->transactional_type == 'App\Models\QRCode' || $value->transactional_type == App\Models\ApiOrder::class): ?>
															<?php if($value->transactional->status == 1): ?>
																<span
																	class="badge badge-success"><?php echo app('translator')->get('Paid'); ?></span>
															<?php else: ?>
																<span
																	class="badge badge-warning"><?php echo app('translator')->get('Pending'); ?></span>
															<?php endif; ?>
														<?php elseif($value->transactional_type == 'App\Models\VirtualCardTransaction'): ?>
															<span
																class="badge badge-success"><?php echo app('translator')->get('Completed'); ?></span>
														<?php elseif($value->transactional_type == 'App\Models\VirtualCardOrder'): ?>
															<span
																class="badge badge-danger"><?php echo app('translator')->get('Return'); ?></span>
														<?php elseif($value->transactional_type == \App\Models\Fund::class && optional($value->transactional)->card_order_id != null): ?>
															<span
																class="badge badge-success"><?php echo app('translator')->get('Add'); ?></span>
														<?php elseif($value->transactional_type == 'App\Models\BillPay' && $value->currency_code != null): ?>
															<span
																class="badge badge-success"><?php echo app('translator')->get('Paid'); ?></span>
														<?php elseif($value->transactional_type == 'App\Models\BillPay' && $value->currency_code == null): ?>
															<span
																class="badge badge-danger"><?php echo app('translator')->get('Return'); ?></span>
														<?php endif; ?>
													</td>
													<td data-label="<?php echo app('translator')->get('Transaction At'); ?>"> <?php echo e(dateTime($value->created_at)); ?> </td>
												</tr>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
												<tr>
													<th colspan="100%" class="text-center"><?php echo app('translator')->get('No data found'); ?></th>
												</tr>
											<?php endif; ?>
											</tbody>
										</table>
									</div>
									<div class="card-footer">
										<?php echo e($transactions->links()); ?>

									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

		</section>
	</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/admin/transaction/index.blade.php ENDPATH**/ ?>