<?php $__env->startSection('page_title', __('Category')); ?>
<?php $__env->startPush('extra_styles'); ?>
	<link rel="stylesheet" href="<?php echo e(asset('assets/dashboard/css/dataTables.bootstrap4.min.css')); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
	<div id="category" v-cloak>
		<div class="main-content">
			<section class="section">
				<div class="section-header">
					<h1><?php echo app('translator')->get('Category'); ?></h1>
					<div class="section-header-breadcrumb">
						<div class="breadcrumb-item active">
							<a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
						</div>
						<div class="breadcrumb-item"><?php echo app('translator')->get('Category'); ?></div>
					</div>
				</div>
				<div class="section-body">
					<div class="row mt-sm-4">
						<div class="col-12 col-md-12 col-lg-12">
							<div class="container-fluid" id="container-wrapper">
								<div class="row justify-content-md-center">
									<div class="col-lg-12">
										<div class="card mb-4 card-primary shadow">
											<div
												class="card-header py-3 d-flex flex-wrap flex-row align-items-center justify-content-between">
												<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Category'); ?></h6>
												<a href="javascript:void(0)" data-target="#addCategory"
												   @click="makeEmpty"
												   data-toggle="modal"
												   class="btn btn-primary"><?php echo app('translator')->get('Create Category'); ?></a>
											</div>
											<div class="card-body">
												<div class="table-responsive">
													<table
														class="table table-striped table-hover align-items-center table-flush"
														id="data-table">
														<thead class="thead-light">
														<tr>
															<th><?php echo app('translator')->get('SL.'); ?></th>
															<th><?php echo app('translator')->get('Name'); ?></th>
															<th><?php echo app('translator')->get('Active Products'); ?></th>
															<th><?php echo app('translator')->get('Status'); ?></th>
															<th><?php echo app('translator')->get('Action'); ?></th>
														</tr>
														</thead>
														<tbody>
														<?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
															<tr>
																<td data-label="<?php echo app('translator')->get('SL.'); ?>"><?php echo e(++$key); ?></td>
																<td data-label="<?php echo app('translator')->get('Name'); ?>"><?php echo e($item->name); ?></td>
																<td data-label="<?php echo app('translator')->get('Active Products'); ?>"><span class="badge badge-success"><?php echo e($item->active_products_count); ?></span></td>
																<td data-label="<?php echo app('translator')->get('Status'); ?>">
																	<?php if($item->status == 1): ?>
																		<span
																			class="badge badge-info"><?php echo app('translator')->get('Active'); ?></span>
																	<?php else: ?>
																		<span
																			class="badge badge-warning"><?php echo app('translator')->get('Inactive'); ?></span>
																	<?php endif; ?>
																</td>
																<td data-label="<?php echo app('translator')->get('Action'); ?>">
																	<a href="javascript:void(0)"
																	   @click="edit(<?php echo e($item); ?>)"
																	   data-target="#editCategory"
																	   data-toggle="modal"
																	   class="btn btn-outline-primary btn-sm mr-2"><i
																			class="fas fa-edit"></i></a>
																	<a href="javascript:void(0)"
																	   data-target="#categoryDelete"
																	   data-toggle="modal"
																	   data-route="<?php echo e(route('category.delete',$item->id)); ?>"
																	   class="btn btn-outline-danger btn-sm deleteCategory"><i
																			class="fas fa-trash"></i></a>
																</td>
															</tr>
														<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
														</tbody>
													</table>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>
		</div>
		<?php echo $__env->make('user.store.category.modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
	</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('extra_scripts'); ?>
	<script src="<?php echo e(asset('assets/dashboard/js/jquery.dataTables.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/dashboard/js/dataTables.bootstrap4.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('scripts'); ?>
	<script>
		'use strict'
		var newApp = new Vue({
			el: "#category",
			data: {
				item: {
					name: "", status: "", id: ""
				},
				nameError: ""
			},
			mounted() {
				this.item.status = 1;
			},
			methods: {
				save() {
					this.makeError();
					axios.post("<?php echo e(route('category.save')); ?>", this.item)
						.then(function (response) {
							console.log(response)
							if (response.data.status == 'success') {
								window.location.href = response.data.url;
							}
						})
						.catch(function (error) {
							let errors = error.response.data;
						});
				},
				edit(obj) {
					this.item.name = obj.name;
					this.item.id = obj.id;
					this.item.status = obj.status;
				},
				update() {
					this.makeError();
					axios.post("<?php echo e(route('category.update')); ?>", this.item)
						.then(function (response) {
							console.log(response)
							if (response.data.status == 'success') {
								window.location.href = response.data.url;
							}
						})
						.catch(function (error) {
							let errors = error.response.data;
						});
				},
				makeError() {
					if (!this.item.name) {
						this.nameError = "Name Field is required"
					}
				},
				makeEmpty() {
					this.item.name = "";
					this.item.status = 1;
					this.nameError = "";
				}
			},
		})
		$(document).ready(function () {
			$('#data-table').dataTable({
				"aaSorting": [],
				"ordering": false
			});
		});

		$(document).on('click', '.deleteCategory', function () {
			var route = $(this).data('route');
			$('.deleteCategoryForm').attr('action', route);
		})

		$(document).ready(function () {
			$('[data-toggle="tooltip"]').tooltip();
		});

	</script>
	<?php if($errors->any()): ?>
		<?php
			$collection = collect($errors->all());
			$errors = $collection->unique();
		?>
		<script>
			"use strict";
			<?php $__currentLoopData = $errors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			Notiflix.Notify.Failure("<?php echo e(trans($error)); ?>");
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		</script>
	<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/user/store/category/index.blade.php ENDPATH**/ ?>