<?php $__env->startSection('page_title', __('Edit Currency')); ?>
<?php $__env->startSection('content'); ?>
	<div class="main-content">
		<section class="section">
			<div class="section-header">
				<h1><?php echo app('translator')->get('Update Currency'); ?></h1>
				<div class="section-header-breadcrumb">
					<div class="breadcrumb-item active">
						<a href="<?php echo e(route('admin.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
					</div>
					<div class="breadcrumb-item"><a href="<?php echo e(route('currency.index')); ?>"><?php echo app('translator')->get('Currencies'); ?></a></div>
					<div class="breadcrumb-item"><?php echo app('translator')->get('Edit Currency'); ?></div>
				</div>
			</div>

			<div class="section-body">
				<div class="row mt-sm-4">
					<div class="col-12 col-md-4 col-lg-3">
						<?php echo $__env->make('admin.control_panel.components.sidebar', ['settings' => config('generalsettings.settings'), 'suffix' => 'Settings'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
					</div>
					<div class="col-12 col-md-8 col-lg-9">
						<div class="container-fluid" id="container-wrapper">
							<div class="row justify-content-md-center">
								<div class="col-lg-12">
									<div class="card mb-4 card-primary shadow">
										<div
											class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
											<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Edit Currency'); ?></h6>
											<a href="<?php echo e(route('currency.index')); ?>" class="btn btn-sm btn-outline-primary"> <i
													class="fas fa-arrow-left"></i> <?php echo app('translator')->get('Back'); ?></a>
										</div>
										<div class="card-body">
											<form method="post" action="<?php echo e(route('currency.update',$currency)); ?>"
												  enctype="multipart/form-data">
												<?php echo csrf_field(); ?>
												<?php echo method_field('PUT'); ?>
												<div class="row">
													<div class="col-md-6">
														<div class="form-group">
															<label for="name"><?php echo app('translator')->get('Name'); ?></label>
															<input type="text" name="name"
																   placeholder="<?php echo app('translator')->get('eg:- US Doller'); ?>"
																   value="<?php echo e($currency->name); ?>"
																   class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
															<div
																class="invalid-feedback"><?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?></div>
														</div>
													</div>

													<div class="col-md-6">
														<div class="form-group">
															<label for="code"><?php echo app('translator')->get('Code'); ?></label>
															<input type="text" name="code"
																   placeholder="<?php echo app('translator')->get('eg:- USD'); ?>"
																   value="<?php echo e($currency->code); ?>"
																   class="form-control code <?php $__errorArgs = ['code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
															<div
																class="invalid-feedback"><?php $__errorArgs = ['code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?></div>
														</div>
													</div>

													<div class="col-md-6">
														<div class="form-group">
															<label for="symbol"><?php echo app('translator')->get('Symbol'); ?></label>
															<input type="text" name="symbol"
																   placeholder="<?php echo app('translator')->get('eg:- $'); ?>"
																   value="<?php echo e($currency->symbol); ?>"
																   class="form-control <?php $__errorArgs = ['symbol'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
															<div
																class="invalid-feedback"><?php $__errorArgs = ['symbol'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?></div>
														</div>
													</div>

													<div class="col-md-6">
														<div class="form-group">
															<label for="exchange_rate"><?php echo app('translator')->get('Exchange Rate'); ?></label>
															<div class="input-group input-group-sm">
																<div class="input-group-prepend"><span
																		class="input-group-text">1 <?php echo e(__(basicControl()->base_currency_code)); ?> <?php echo app('translator')->get('='); ?> </span>
																</div>
																<input type="text" name="exchange_rate"
																	   placeholder="<?php echo app('translator')->get('eg:- 0.00'); ?>"
																	   value="<?php echo e(getAmount($currency->exchange_rate)); ?>"
																	   class="form-control rate <?php $__errorArgs = ['exchange_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
																<div class="input-group-append"><span
																		class="input-group-text rate"></span></div>
																<div
																	class="invalid-feedback"><?php $__errorArgs = ['exchange_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?></div>
															</div>
														</div>
													</div>

													<div class="col-md-6">
														<div class="form-group">
															<label for="currency_type"><?php echo app('translator')->get('Currency Type'); ?></label>
															<select id="currency_type" name="currency_type"
																	class="form-control <?php $__errorArgs = ['currency_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
																<option
																	value="0" <?php echo e((old('currency_type',$currency->currency_type) == 0) ? 'selected' : ''); ?>><?php echo app('translator')->get('Crypto'); ?></option>
																<option
																	value="1" <?php echo e((old('currency_type',$currency->currency_type) == 1) ? 'selected' : ''); ?>><?php echo app('translator')->get('Fiat'); ?></option>
															</select>
															<div
																class="invalid-feedback"><?php $__errorArgs = ['currency_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?></div>
														</div>
													</div>
													<div class="col-md-6">
														<div class="form-group">
															<label><?php echo app('translator')->get('Active Currency'); ?></label>
															<div class="selectgroup w-100">
																<label class="selectgroup-item">
																	<input type="radio" name="is_active" value="0"
																		   class="selectgroup-input" <?php echo e(old('is_active', $currency->is_active) == 0 ? 'checked' : ''); ?>>
																	<span class="selectgroup-button"><?php echo app('translator')->get('OFF'); ?></span>
																</label>
																<label class="selectgroup-item">
																	<input type="radio" name="is_active" value="1"
																		   class="selectgroup-input" <?php echo e(old('is_active', $currency->is_active) == 1 ? 'checked' : ''); ?>>
																	<span class="selectgroup-button"><?php echo app('translator')->get('ON'); ?></span>
																</label>
															</div>
															<?php $__errorArgs = ['is_active'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
															<span class="text-danger" role="alert">
														<strong><?php echo e(__($message)); ?></strong>
													</span>
															<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
														</div>
													</div>
													<div class="col-md-6">
														<div class="form-group mb-4">
															<label class="col-form-label"><?php echo app('translator')->get('Logo'); ?></label>
															<div id="image-preview" class="image-preview"
																 style="background-image: url(<?php echo e(getFile(config('location.currencyLogo.path').$currency->logo) ? : 0); ?>);">
																<label for="image-upload"
																	   id="image-label"><?php echo app('translator')->get('Choose logo'); ?></label>
																<input type="file" name="logo"
																	   class="<?php $__errorArgs = ['logo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
																	   id="image-upload"/>
															</div>
															<div class="invalid-feedback">
																<?php $__errorArgs = ['logo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
															</div>
														</div>
													</div>
												</div>
												<input type="submit" class="btn btn-primary btn-sm btn-block"
													   value="<?php echo app('translator')->get('Save Changes'); ?>">
											</form>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

		</section>
	</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('extra_scripts'); ?>
	<script src="<?php echo e(asset('assets/dashboard/js/jquery.uploadPreview.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('scripts'); ?>
	<script>
		'use strict'
		$(document).ready(function () {
			setCurrencyCode();

			function setCurrencyCode() {
				$('.rate').text($('.code').val());
			}

			$(document).on('input', '.code', function () {
				setCurrencyCode();
			})

			$.uploadPreview({
				input_field: "#image-upload",
				preview_box: "#image-preview",
				label_field: "#image-label",
				label_default: "Choose logo",
				label_selected: "Change logo",
				no_label: false
			});
		});
	</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/admin/currency/edit.blade.php ENDPATH**/ ?>