<?php $__env->startSection('page_title',__('Send Payout Request')); ?>
<?php $__env->startSection('content'); ?>
	<div class="main-content">
		<section class="section">
			<div class="section-header">
				<h1><?php echo app('translator')->get('Send Payout Request'); ?></h1>
				<div class="section-header-breadcrumb">
					<div class="breadcrumb-item active">
						<a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
					</div>
					<div class="breadcrumb-item"><?php echo app('translator')->get('Send Payout Request'); ?></div>
				</div>
			</div>
			<!------ alert ------>
			<div class="row ">
				<div class="col-md-12">
					<div class="bd-callout bd-callout-primary mx-2">
						<i class="fa-3x fas fa-info-circle text-primary"></i> <?php echo app('translator')->get(@$template->description->short_description); ?>
					</div>
				</div>
			</div>


			<div class="row mb-3">
				<div class="container-fluid" id="container-wrapper">
					<div class="row justify-content-md-center">
						<div class="col-md-6">
							<div class="card mb-4 card-primary shadow">
								<div
									class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
									<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Choose a payout method'); ?></h6>
								</div>
								<div class="card-body payout">
									<form action="<?php echo e(route('payout.request')); ?>" method="post">
										<?php echo csrf_field(); ?>
										<div class="row">
											<div class="col-md-12">
												<label for="methodId"><?php echo app('translator')->get('Payout Method'); ?></label>
												<div class="form-group">
													<?php $__currentLoopData = $payoutMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
														<div class="form-check form-check-inline mb-4 ml-2">
															<input class="form-check-input" type="radio" name="methodId"
																   id="<?php echo e($key); ?>"
																   value="<?php echo e($value->id); ?>" <?php echo e(old('methodId') == $value->id ? ' checked' : ''); ?>>
															<label class="form-check-label" for="<?php echo e($key); ?>">
																<img
																	src="<?php echo e(getFile(config('location.methodLogo.path').$value->logo)); ?>">
																<span><?php echo e(__($value->methodName)); ?></span>
															</label>
														</div>
													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
												</div>
											</div>
										</div>
										<div class="row">
											<div class="col-md-12">
												<div class="form-group">
													<label for="amount"><?php echo app('translator')->get('Amount'); ?></label>
													<div class="input-group input-group-sm">
														<input type="text" name="amount" value="<?php echo e(old('amount')); ?>"
															   placeholder="<?php echo app('translator')->get('Enter Amount'); ?>"
															   class="form-control <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
														<div class="input-group-prepend">
															<span
																class="input-group-text"><?php echo app('translator')->get(optional($baseControl->currency)->code); ?></span>
														</div>
													</div>
													<div
														class="invalid-feedback"><?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?></div>
												</div>
											</div>
										</div>
										<button type="submit" id="submit"
												class="btn btn-primary btn-sm btn-block"><?php echo app('translator')->get('Continue'); ?></button>
									</form>
								</div>
							</div>
						</div>
						<div class="col-md-6">
							<div class="card mb-4 card-primary shadow">
								<div
									class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
									<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Details'); ?></h6>
								</div>
								<div class="card-body showCharge d-none">
									<ul class="list-group">
										<li class="list-group-item d-flex justify-content-between align-items-center">
											<span><?php echo app('translator')->get('Fixed charge'); ?></span>
											<span class="text-danger" id="fixed_charge"></span>
										</li>
										<li class="list-group-item d-flex justify-content-between align-items-center">
											<span><?php echo app('translator')->get('Percentage charge'); ?></span><span class="text-danger"
																						 id="percentage_charge"></span>
										</li>
										<li class="list-group-item d-flex justify-content-between align-items-center">
											<span><?php echo app('translator')->get('Min limit'); ?></span>
											<span class="text-info" id="min_limit"></span>
										</li>
										<li class="list-group-item d-flex justify-content-between align-items-center">
											<span><?php echo app('translator')->get('Max limit'); ?></span>
											<span class="text-info" id="max_limit"></span>
										</li>
									</ul>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

		</section>
	</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
	<script>
		'use strict';
		$(document).ready(function () {
			$(document).on('input', 'input[name="amount"]', function () {
				let limit = '<?php echo e(optional($baseControl->currency)->currency_type == 0 ? 8 : 2); ?>';
				let amount = $(this).val();
				let fraction = amount.split('.')[1];
				if (fraction && fraction.length > limit) {
					amount = (Math.floor(amount * Math.pow(10, limit)) / Math.pow(10, limit)).toFixed(limit);
					$(this).val(amount);
				}
			});

			$(document).on('change', "input[type=radio][name=methodId]", function (e) {
				let methodId = this.value;
				$.ajax({
					method: "GET",
					url: "<?php echo e(route('payout.checkLimit')); ?>",
					dataType: "json",
					data: {'methodId': methodId}
				})
					.done(function (response) {
						let amountField = $('#amount');
						if (response.status) {
							$('.showCharge').removeClass('d-none');
							$('#fixed_charge').html(response.fixed_charge + ' ' + response.currency_code);
							$('#percentage_charge').html(response.percentage_charge + ' ' + response.currency_code);
							$('#min_limit').html(parseFloat(response.min_limit).toFixed(response.currency_limit) + ' ' + response.currency_code);
							$('#max_limit').html(parseFloat(response.max_limit).toFixed(response.currency_limit) + ' ' + response.currency_code);
						} else {
							$('.showCharge').addClass('d-none');
						}
					});
			});
		});
	</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/user/payout/request.blade.php ENDPATH**/ ?>