<?php $__env->startSection('page_title', __('Store Fronts')); ?>
<?php $__env->startPush('extra_styles'); ?>
	<link rel="stylesheet" href="<?php echo e(asset('assets/dashboard/css/dataTables.bootstrap4.min.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
	<div class="main-content" id="store" v-cloak>
		<section class="section">
			<div class="section-header">
				<h1><?php echo app('translator')->get('Store Fronts'); ?></h1>
				<div class="section-header-breadcrumb">
					<div class="breadcrumb-item active">
						<a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
					</div>
					<div class="breadcrumb-item"><?php echo app('translator')->get('Store Fronts'); ?></div>
				</div>
			</div>
			<div class="section-body">
				<div class="row mt-sm-4">
					<div class="col-12 col-md-12 col-lg-12">
						<div class="container-fluid" id="container-wrapper">
							<div class="row justify-content-md-center">
								<div class="col-lg-12">
									<div class="card mb-4 card-primary shadow">
										<div
											class="card-header py-3 d-flex flex-wrap flex-row align-items-center justify-content-between">
											<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Store Fronts'); ?></h6>
											<a href="<?php echo e(route('store.create')); ?>"
											   class="btn btn-primary"><?php echo app('translator')->get('Create Store'); ?></a>
										</div>
										<div class="card-body">
											<div class="table-responsive">
												<table
													class="table table-striped table-hover align-items-center table-flush"
													id="data-table">
													<thead class="thead-light">
													<tr>
														<th><?php echo app('translator')->get('SL.'); ?></th>
														<th><?php echo app('translator')->get('Image'); ?></th>
														<th><?php echo app('translator')->get('Name'); ?></th>
														<th><?php echo app('translator')->get('Product'); ?></th>
														<th><?php echo app('translator')->get('Shipping Charge'); ?></th>
														<th><?php echo app('translator')->get('Status'); ?></th>
														<th><?php echo app('translator')->get('Delivery Note'); ?></th>
														<th><?php echo app('translator')->get('Copy Link'); ?></th>
														<th><?php echo app('translator')->get('Action'); ?></th>
													</tr>
													</thead>
													<tbody>
													<?php $__currentLoopData = $stores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
														<tr>
															<td data-label="<?php echo app('translator')->get('SL.'); ?>"><?php echo e(++$key); ?></td>
															<td data-label="<?php echo app('translator')->get('Image'); ?>">
																<img class="img-store-custom"
																	 src="<?php echo e(getFile(config('location.store.path').$item->image)); ?>">
															</td>
															<td data-label="<?php echo app('translator')->get('Name'); ?>"><?php echo e($item->name); ?></td>
															<td data-label="<?php echo app('translator')->get('Product'); ?>"><span
																	class="badge badge-info"><?php echo e($item->products_map_count); ?></span>
															</td>
															<td data-label="<?php echo app('translator')->get('Shipping Charge'); ?>">
																<?php if($item->shipping_charge == 1): ?>
																	<span
																		class="badge badge-info"><?php echo app('translator')->get('Active'); ?></span>
																<?php else: ?>
																	<span
																		class="badge badge-warning"><?php echo app('translator')->get('Inactive'); ?></span>
																<?php endif; ?>
															</td>
															<td data-label="<?php echo app('translator')->get('Status'); ?>">
																<?php if($item->status == 1): ?>
																	<span
																		class="badge badge-info"><?php echo app('translator')->get('Active'); ?></span>
																<?php else: ?>
																	<span
																		class="badge badge-warning"><?php echo app('translator')->get('Inactive'); ?></span>
																<?php endif; ?>
															</td>
															<td data-label="<?php echo app('translator')->get('Delivery Note'); ?>">
																<span
																	class="badge badge-success"><?php echo e(ucfirst($item->delivery_note)); ?></span>
															</td>
															<td data-label="<?php echo app('translator')->get('Copy Link'); ?>">
																<a href="javascript:void(0)"
																   @click.stop.prevent="copyTestingCode('<?php echo e(route('public.view',$item->link)); ?>')">
																	<i class="fas fa-link"></i>
																</a>
															</td>
															<td data-label="<?php echo app('translator')->get('Action'); ?>">
																<div class="dropdown">
																	<button
																		class="btn btn-sm btn-primary dropdown-toggle"
																		type="button" data-toggle="dropdown"
																		data-boundary="window" aria-haspopup="true"
																		aria-expanded="false"><?php echo app('translator')->get('More Action'); ?>
																	</button>
																	<div class="dropdown-menu">
																		<a class="dropdown-item text-primary"
																		   href="<?php echo e(route('store.edit',$item->id)); ?>">
																			<i class="fas fa-edit mr-2"></i><?php echo app('translator')->get('Edit'); ?>
																		</a>
																		<a class="dropdown-item text-danger deleteStore"
																		   data-target="#storeDelete"
																		   data-toggle="modal"
																		   data-route="<?php echo e(route('store.delete',$item->id)); ?>"
																		   href="javascript:void(0)"><i
																				class="fa fa-trash mr-2"></i> <?php echo app('translator')->get('Delete'); ?>
																		</a>
																	</div>
																</div>
															</td>
														</tr>
													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
													</tbody>
												</table>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

		</section>
	</div>
	<?php echo $__env->make('user.store.modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('extra_scripts'); ?>
	<script src="<?php echo e(asset('assets/dashboard/js/jquery.dataTables.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/dashboard/js/dataTables.bootstrap4.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('scripts'); ?>
	<script>
		'use strict'
		$(document).ready(function () {
			$('#data-table').dataTable({
				"aaSorting": [],
				"ordering": false
			});
		});

		$(document).on('click', '.deleteStore', function () {
			var route = $(this).data('route');
			$('.deleteStoreForm').attr('action', route);
		})

		var newApp = new Vue({
			el: "#store",
			data: {},
			mounted() {
			},
			methods: {
				copyTestingCode(copyText) {
					navigator.clipboard.writeText(copyText);
					Notiflix.Notify.Success('Link Copied');
				},
			},
		})
	</script>
	<?php if($errors->any()): ?>
		<?php
			$collection = collect($errors->all());
			$errors = $collection->unique();
		?>
		<script>
			"use strict";
			<?php $__currentLoopData = $errors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			Notiflix.Notify.Failure("<?php echo e(trans($error)); ?>");
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		</script>
	<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/user/store/storeList.blade.php ENDPATH**/ ?>