
<?php $__env->startSection('page_title', __('Currencies')); ?>
<?php $__env->startSection('content'); ?>
	<div class="main-content">
		<section class="section">
			<div class="section-header">
				<h1><?php echo app('translator')->get('Currencies'); ?></h1>
				<div class="section-header-breadcrumb">
					<div class="breadcrumb-item active">
						<a href="<?php echo e(route('admin.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
					</div>
					<div class="breadcrumb-item"><?php echo app('translator')->get('Currencies'); ?></div>
				</div>
			</div>

			<div class="section-body">
				<div class="row mt-sm-4">
					<div class="col-12 col-md-4 col-lg-3">
						<?php echo $__env->make('admin.control_panel.components.sidebar', ['settings' => config('generalsettings.settings'), 'suffix' => 'Settings'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
					</div>
					<div class="col-12 col-md-8 col-lg-9">
						<div class="container-fluid" id="container-wrapper">
							<div class="row justify-content-md-center">
								<div class="col-lg-12">
									<div class="card mb-4 card-primary shadow">
										<div
											class="card-header py-3 d-flex flex-wrap flex-row align-items-center justify-content-between">
											<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Currencies'); ?></h6>
											<span>
											<a href="<?php echo e(route('currency.create')); ?>"
											   class="btn btn-sm btn-outline-primary"><?php echo app('translator')->get('Add New'); ?></a>
										</span>
										</div>
										<div class="card-body">
											<div class="table-responsive">
												<table
													class="table table-striped table-hover align-items-center table-flush">
													<thead class="thead-light">
													<tr>
														<th><?php echo app('translator')->get('Name'); ?></th>
														<th><?php echo app('translator')->get('Code'); ?></th>
														<th><?php echo app('translator')->get('Rate'); ?></th>
														<th><?php echo app('translator')->get('Status'); ?></th>
														<th><?php echo app('translator')->get('Type'); ?></th>
														<th colspan="2"><?php echo app('translator')->get('Action'); ?></th>
													</tr>
													</thead>
													<tbody>
													<?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
														<tr>
															<td data-label="<?php echo app('translator')->get('Name'); ?>">
																<div class="d-flex no-block align-items-center">
																	<div class="mr-2"><img
																			class="img-profile-custom rounded-circle"
																			src="<?php echo e(asset('assets/upload/currencyLogo').'/'.$currency->logo); ?>"
																			alt="<?php echo e(__($currency->name)); ?>"
																			class="rounded-circle" width="35"
																			height="35"></div>
																	<div class="">
																		<p class="text-dark mb-0 font-weight-medium"><?php echo e(__($currency->name)); ?></p>
																	</div>
																</div>
															</td>
															<td data-label="<?php echo app('translator')->get('Code'); ?>"><?php echo e(__($currency->code)); ?></td>
															<td data-label="<?php echo app('translator')->get('Rate'); ?>"><span
																	class="font-weight-bold"><?php echo e(__($currency->symbol)); ?></span><?php echo e((getAmount($currency->exchange_rate))); ?>

															</td>
															<td data-label="<?php echo app('translator')->get('Status'); ?>">
																<?php if($currency->is_default): ?>
																	<span
																		class="badge badge-success"><?php echo app('translator')->get('Default'); ?></span>
																<?php elseif($currency->is_active): ?>
																	<span
																		class="badge badge-info"><?php echo app('translator')->get('Active'); ?></span>
																<?php else: ?>
																	<span
																		class="badge badge-warning"><?php echo app('translator')->get('Inactive'); ?></span>
																<?php endif; ?>
															</td>
															<td data-label="<?php echo app('translator')->get('Type'); ?>">
																<?php if($currency->currency_type == 0): ?>
																	<span
																		class="badge badge-warning"><?php echo app('translator')->get('Crypto'); ?></span>
																<?php elseif($currency->currency_type == 1): ?>
																	<span class="badge badge-dark"><?php echo app('translator')->get('Fiat'); ?></span>
																<?php endif; ?>
															</td>
															<td data-label="<?php echo app('translator')->get('Action'); ?>">
																<a class="btn btn-sm btn-outline-primary"
																   href="<?php echo e(route('currency.edit',$currency)); ?>">
																	<i class="fas fa-edit"></i>
																</a>
															</td>
															<td data-label="<?php echo app('translator')->get('Action'); ?>">
																<div class="dropdown">
																	<button
																		class="btn btn-sm btn-primary dropdown-toggle"
																		type="button" data-toggle="dropdown"
																		data-boundary="window" aria-haspopup="true"
																		aria-expanded="false"><?php echo app('translator')->get('Edit charges'); ?>
																	</button>
																	<div class="dropdown-menu">
																		<a class="dropdown-item"
																		   href="<?php echo e(route('charge.chargeEdit',[config('transactionType.transfer'),$currency->id])); ?>"><?php echo app('translator')->get('Transfer'); ?></a>
																		<a class="dropdown-item"
																		   href="<?php echo e(route('charge.chargeEdit',[config('transactionType.request'),$currency->id])); ?>"><?php echo app('translator')->get('Request'); ?></a>
																		<a class="dropdown-item"
																		   href="<?php echo e(route('charge.chargeEdit',[config('transactionType.exchange'),$currency->id])); ?>"><?php echo app('translator')->get('Exchange'); ?></a>
																		<a class="dropdown-item"
																		   href="<?php echo e(route('charge.chargeEdit',[config('transactionType.redeem'),$currency->id])); ?>"><?php echo app('translator')->get('Redeem'); ?></a>
																		<a class="dropdown-item"
																		   href="<?php echo e(route('charge.chargeEdit',[config('transactionType.escrow'),$currency->id])); ?>"><?php echo app('translator')->get('Escrow'); ?></a>
																		<a class="dropdown-item"
																		   href="<?php echo e(route('charge.chargeEdit',[config('transactionType.voucher'),$currency->id])); ?>"><?php echo app('translator')->get('Voucher'); ?></a>
																		<a class="dropdown-item"
																		   href="<?php echo e(route('charge.chargeEdit',[config('transactionType.invoice'),$currency->id])); ?>"><?php echo app('translator')->get('Invoice'); ?></a>
																		<a class="dropdown-item"
																		   href="<?php echo e(route('charge.payment.method',[$currency->id])); ?>"><?php echo app('translator')->get('Payment Methods'); ?></a>
																	</div>
																</div>
															</td>
														</tr>
													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
													</tbody>
												</table>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
	</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/admin/currency/index.blade.php ENDPATH**/ ?>