<?php $__env->startSection('page_title', __('Payment Methods')); ?>

<?php $__env->startPush('extra_styles'); ?>
    <link href="<?php echo e(asset('assets/dashboard/css/jquery-ui.min.css')); ?>" rel="stylesheet" type="text/css">
    <link rel="stylesheet" href="<?php echo e(asset('assets/dashboard/css/dataTables.bootstrap4.min.css')); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
<div class="main-content">
	<section class="section">
		<div class="section-header">
			<h1><?php echo app('translator')->get('Payment Methods'); ?></h1>
			<div class="section-header-breadcrumb">
				<div class="breadcrumb-item active">
					<a href="<?php echo e(route('admin.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
				</div>
				<div class="breadcrumb-item"><?php echo app('translator')->get('Payment Methods'); ?></div>
			</div>
		</div>

		<div class="row mb-3">
			<div class="container-fluid" id="container-wrapper">
				<div class="row">
					<div class="col-lg-12">
						<div class="card mb-4 card-primary shadow">
							<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
								<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Payment Methods'); ?></h6>
							</div>
							<div class="card-body">
								<div class="table-responsive">
									<table class="table align-items-center table-bordered" id="payment-method-table">
										<thead class="thead-light">
										<tr>
											<th col="scope"><?php echo app('translator')->get('Name'); ?></th>
											<th col="scope"><?php echo app('translator')->get('Status'); ?></th>
											<th col="scope"><?php echo app('translator')->get('Action'); ?></th>
										</tr>
										</thead>
										<tbody id="sortable">
										<?php if(count($methods) > 0): ?>
											<?php $__currentLoopData = $methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<tr data-code="<?php echo e($method->code); ?>">
													<td data-label="<?php echo app('translator')->get('Name'); ?>"><?php echo e($method->name); ?> </td>
													<td data-label="<?php echo app('translator')->get('Status'); ?>">
														<?php echo $method->status == 1 ? '<span class="badge badge-success badge-sm">'.__('Active').'</span>' : '<span class="badge badge-danger badge-sm">'.__('Inactive').'</span>'; ?>

													</td>
													<td data-label="<?php echo app('translator')->get('Action'); ?>">
														<a href="<?php echo e(route('edit.payment.methods', $method->id)); ?>"
														   class="btn btn-sm btn-outline-primary btn-circle"
														   data-toggle="tooltip"
														   data-placement="top"
														   data-original-title="<?php echo app('translator')->get('Edit this Payment Methods info'); ?>">
															<i class="fa fa-edit"></i> <?php echo app('translator')->get('Edit'); ?>
														</a>
													</td>
												</tr>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										<?php else: ?>
											<tr>
												<td class="text-center text-danger" colspan="8">
													<?php echo app('translator')->get('No Data Found'); ?>
												</td>
											</tr>
										<?php endif; ?>
										</tbody>
									</table>
								</div>
								<div class="card-footer">
									<h5>
										<span class="text-primary"><?php echo app('translator')->get('N.B:'); ?></span>
										<?php echo app('translator')->get('Pull up or down the rows to sort the payment gateways order that how do you want to display the payment gateways in admin and user panel.'); ?>
									</h5>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

	</section>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('extra_scripts'); ?>
    <script src="<?php echo e(asset('assets/dashboard/js/jquery-ui.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/dashboard/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/dashboard/js/dataTables.bootstrap4.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        'use strict'
        $(document).ready(function () {
            $('#payment-method-table').DataTable({
                "paging": false,
                "aaSorting": [],
                "ordering": false
            });
            $("#sortable").sortable({
                update: function (event, ui) {
                    var methods = [];
                    $('#sortable tr').each(function (key, val) {
                        let methodCode = $(val).data('code');
                        methods.push(methodCode);
                    });
                    $.ajax({
                        'url': "<?php echo e(route('sort.payment.methods')); ?>",
                        'method': "POST",
                        'data': {sort: methods},
                        success(response) {
                            return true;
                        }
                    })
                }
            });
            $("#sortable").disableSelection();
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/admin/payment_methods/index.blade.php ENDPATH**/ ?>