<?php $__env->startSection('page_title',__('Order Confirmation')); ?>

<?php $__env->startSection('content'); ?>
	<div class="complete-order">
		<div class="container">
			<div class="row justify-content-center">
				<div class="col-lg-6">
					<div class="text-center">
						<img src="<?php echo e(asset('assets/store/img/icon/package.png')); ?>" alt="..."
							 class="img-fluid icon mb-3"/>
						<h3><?php echo app('translator')->get('Order Confirmation'); ?></h3>
						<p>
							<?php echo app('translator')->get('Hey'); ?> <?php echo e($order->fullname); ?>

							, <?php echo app('translator')->get("We've got your order! We know you’re going to love it. You can track your order here or shop again here.."); ?>
						</p>
						<h5><?php echo app('translator')->get('Your Order ID:'); ?> #<?php echo e($order->order_number); ?></h5>
					</div>
					<div class="order-summary">
						<h4><?php echo app('translator')->get('Order Summary'); ?></h4>
						<?php $__empty_1 = true; $__currentLoopData = $order->orderDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $orderDetail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
							<div class="item">
								<img
									src="<?php echo e(getFile(config('location.product.path').optional($orderDetail->product)->thumbnail)); ?>"
									alt=""/>
								<div class="text">
									<p class="name"><?php echo e(optional($orderDetail->product)->name); ?></p>
									<p class="color">
										<?php $__currentLoopData = $orderDetail->attr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<?php echo e(optional($attr->attrName)->name); ?>:<?php echo e($attr->name); ?>

										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</p>
									<p class="quantity"><?php echo app('translator')->get('QTY:'); ?> <?php echo e($orderDetail->quantity); ?></p>
									<p class="price"><?php echo e(optional($store->user->storeCurrency)->symbol); ?><?php echo e(getAmount($orderDetail->price,2)); ?></p>
								</div>
							</div>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
						<?php endif; ?>
						<div class="checkout-summary">
							<ul>
								<li><?php echo app('translator')->get('Subtotal'); ?>
									<span><?php echo e(optional($store->user->storeCurrency)->symbol); ?><?php echo e(getAmount($order->total_amount,2)); ?></span>
								</li>
								<li><?php echo app('translator')->get('Shipping'); ?>
									<span><?php echo e(optional($store->user->storeCurrency)->symbol); ?><?php echo e(getAmount($order->shipping_charge,2)); ?></span>
								</li>
								<li><?php echo app('translator')->get('Grand Total'); ?>
									<span><?php echo e(optional($store->user->storeCurrency)->symbol); ?><?php echo e(getAmount($order->total_amount+$order->shipping_charge,2)); ?></span>
								</li>
							</ul>
						</div>
						<div class="text-center mt-3">
							<a href="<?php echo e(route('public.product.track',$link)); ?>"
							   class="btn-custom"><?php echo app('translator')->get('track your order'); ?></a>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('extra_scripts'); ?>
	<script>
		'use script'
		shoppingCart.clearCart();
	</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('user.layouts.storeMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/user/store/orderConfirm.blade.php ENDPATH**/ ?>